jQuery( function( $ ) {
    $( document ).on( 'click', '.ld-edd-retroactive-tool', function( e ) {
        e.preventDefault();

		$( this ).addClass( 'in-progress' ).attr( 'disabled', 'disabled' ).text( '' ).append( '<span class="loader"></span>');

		$( this ).after( '<p class="ld-edd-retroactive-tool-notice">' + LearnDash_EDD_Tools.text.keep_page_open + '</p>' ).after( '<span class="ld-edd-retroactive-tool-status"></span><div class="clear"></div>' );

        learndash_edd_run_retroactive_tool();
    } );

    function learndash_edd_run_retroactive_tool( step = 1 ) {
        $.ajax( {
			url: ajaxurl,
			type: 'POST',
			dataType: 'json',
			data: {
				action: 'ld_edd_retroactive_access',
				nonce: LearnDash_EDD_Tools.nonce.retroactive_access,
				step: step,
			},
		} ).done( function( data ) {
			console.log( data );
			if ( typeof( data ) != 'undefined' ) {
				if ( data.step !== 'complete' ) {
					$( '.ld-edd-retroactie-tool-status' ).text( LearnDash_EDD_Tools.text.status + ': ' + data.percentage + '%' );

					$( '.ld-edd-retroactive-tool-notice' ).text( LearnDash_EDD_Tools.text.keep_page_open );

					learndash_edd_run_retroactive_tool( data.step );
				} else {
					$( '.ld-edd-retroactive-tool' ).text( LearnDash_EDD_Tools.text.retroactive_button ).removeClass( 'in-progress' ).removeAttr( 'disabled' );
					
					$( '.ld-edd-retroactive-tool-status' ).text( LearnDash_EDD_Tools.text.status + ': ' + LearnDash_EDD_Tools.text.complete );

					$( '.ld-edd-retroactive-tool-notice' ).remove();
				}
			}
		});
    }
} );